
export WANDB_PROJECT=Video-GRPO
export WANDB_NAME=Qwen2.5_7b_TG

export PYTHONPATH=".:$PYTHONPATH"
OUTDIR=outputs/sft_scanrefer

export DEBUG_MODE="true"
export LOG_PATH="logs/sft_scanrefer.log"

CUDA_VISIBLE_DEVICES=0,2 torchrun --nproc_per_node="2" \
    --nnodes="1" \
    --node_rank="0" \
    --master_addr="127.0.0.1" \
    --master_port="12361" \
    src/open_r1/sft.py \
    --deepspeed scripts/zero3_offload.json \
    --output_dir $OUTDIR \
    --model_name_or_path /data2/huggingface/Qwen/Qwen2.5-VL-7B-Instruct \
    --preprocessed_data_path /data2/datasets/scannet/ScanRefer_preprocessed_data_maxpix_3584 \
    --train_data_path ./dataset/scanrefer/train.json \
    --eval_data_path ./dataset/scanrefer/train.json \
    --video_folder /data2/datasets/scannet/video \
    --dataset_name scanrefer \
    --per_device_train_batch_size 1 \
    --gradient_accumulation_steps 4 \
    --logging_steps 20 \
    --bf16 \
    --torch_dtype bfloat16 \
    --data_seed 42 \
    --gradient_checkpointing true \
    --attn_implementation flash_attention_2 \
    --num_train_epochs 2 \
    --run_name $WANDB_NAME \
    --report_to wandb \
    --save_steps 50 \
    --save_only_model true
